from pages.base_page import BasePage


class ClickEventsPage(BasePage):
    PAGE_URL = "https://practice-automation.com/click-events/"

    CAT_BUTTON = ("xpath", '//button[@onclick="catSound()"]')
    DOG_BUTTON = ("xpath", '//button[@onclick="dogSound()"]')
    PIG_BUTTON = ("xpath", '//button[@onclick="pigSound()"]')
    COW_BUTTON = ("xpath", '//button[@onclick="cowSound()"]')

    RESULT_TEXT = ("id", "demo")

    def click_cat_button(self):
        self.find_and_click(self.CAT_BUTTON)

    def click_dog_button(self):
        self.find_and_click(self.DOG_BUTTON)

    def click_pig_button(self):
        self.find_and_click(self.PIG_BUTTON)

    def click_cow_button(self):
        self.find_and_click(self.COW_BUTTON)

    def get_result_text(self):
        return self.driver.find_element(*self.RESULT_TEXT).text